#!/bin/bash
cd /var/cache/adblock/

# source: https://github.com/pi-hole/pi-hole/blob/963eacfe0537a7abddf30441c754c67ca1e40965/gravity.sh
sources=(
    'https://adaway.org/hosts.txt'
    'http://adblock.gjtech.net/?format=unix-hosts'
    # 'http://adblock.mahakala.is/'
    'http://hosts-file.net/.%5Cad_servers.txt'
    'http://www.malwaredomainlist.com/hostslist/hosts.txt'
    'http://pgl.yoyo.org/adservers/serverlist.php?'
    'http://someonewhocares.org/hosts/hosts'
    'http://winhelp2002.mvps.org/hosts.txt'
)

# query all sources
i=0
for s in ${sources[@]}; do
    i=$((i+1))
    wget -O hosts-$i.txt.new "$s" && mv hosts-$i.txt.new hosts-$i.txt
done

# select hostnames from hosts files (sed removes the IP, removes comments and trailing whitespace)
for file in hosts-?.txt; do
    grep -E '^(127\.0\.0\.1|0\.0\.0\.0)\s' $file | sed 's/^\S*\s\+//;s/#.*//;s/\s\+$//'
# now generate a single addn-hosts file (sed adds the target, a blackhole IP configured on this host)
done | sort -u | grep -Ev '^local(host(.localdomain)?)?$' | sed 's/^/10.0.13.13 /' > hosts.txt
